<?php
$src = $argv[1];
$img = imagecreatefromstring(file_get_contents($src));

// Create a new true color image
$width = imagesx($img);
$height = imagesy($img);
$new = imagecreatetruecolor($width, $height);

// Allocate a white color and fill the new image with it
$background = imagecolorallocate($new, 255, 255, 255);
imagefilledrectangle($new, 0, 0, $width, $height, $background);

// Copy and resample the old image into the new image
imagecopyresampled($new, $img, 0, 0, 0, 0, $width, $height, $width, $height);

$newName = $argv[2];
imagejpeg($new, $newName);

if ($src != $newName) {
    unlink($src);
}
imagedestroy($img);
imagedestroy($new);

echo "Done";