import sys
import time
import os
import undetected_chromedriver as uc
from selenium.webdriver.common.by import By
from selenium.common.exceptions import NoSuchElementException

if __name__ == '__main__':
    try:
        headless = sys.argv[1]
    except IndexError:
        headless = False
    headless = headless == "headless"
    print(headless)
    driver = uc.Chrome(headless=False, use_subprocess=True)
    driver.get('https://google.com')
    time.sleep(1)
    log = open("log", 'a')
    while True:
        command = input().strip()
        log.write(command + "\n")
        log.flush()
        if command == 'close':
            driver.close()
            driver.quit()
            log.flush()
            log.close()
            print("done")
            break
        elif command == 'ru':
            # Visit rozetka.com.ua and set 'slang' cookie to 'ru'
            driver.get('https://rozetka.com.ua')
            # Delete any existing 'slang' cookie first
            try:
                driver.delete_cookie('slang')
            except:
                pass  # Cookie might not exist yet
            # Add the new cookie
            driver.add_cookie({'name': 'slang', 'value': 'ru'})
            # Refresh the page to apply the cookie
            driver.refresh()
            time.sleep(1)
        else:
            driver.get(command)
            time.sleep(1)

        # Check if div#description exists and scroll to it
        try:
            description_element = driver.find_element(By.CSS_SELECTOR, "div#description")
            # Scroll to the element
            driver.execute_script("arguments[0].scrollIntoView();", description_element)
            # Wait for 200ms after scrolling
            time.sleep(0.2)
        except NoSuchElementException:
            # Element doesn't exist, continue with the script
            pass

        if os.path.exists("transfer"):
            os.remove("transfer")
        while True:
            x = driver.page_source
            if len(x) < 150:
                time.sleep(0.2)
                continue
            file = open("transfer", "w", encoding="utf-8")
            file.write(driver.page_source)
            file.close()
            break

        print("done")